<?php

// (c) 2002 Michal Kebrt
// michalek.k@seznam.cz

// vypisuje odkazy pro zobrazeni statistiky za dane obdobi
function dateLink($from, $to, $text) {
    global $month, $year;
    
    if (mktime(0,0,0, $month, $from, $year) <= mktime(0,0,0, date('m'), date('d'), date('Y'))) {
        echo '<a href="stat.php?month=' . $month . '&amp;year=' . $year . '&amp;from_date=' . $year . '-' .
             $month . '-' . $from . '&amp;to_date=' . $year . '-' . $month . '-' . $to . '">';
        echo $text;
        echo '</a>';
    } else {
        echo $text;
    }
 }

// pokud nejsou promenne zinicializovany, vlozi aktualni hodnoty
$month = date('m');
$year = date('Y');
if ( isset($_GET['month']) and ($_GET['month'] <= 13) and ($_GET['month'] >= 0) ) $month = $_GET['month'];
if ( isset($_GET['year']) and ($_GET['year'] <= 2035) and ($_GET['year'] >= 1970) ) $year = $_GET['year'];

// prevod na korektni hodnoty
$year = date('Y', mktime(0,0,0, $month, 1, $year));
$month = date('m', mktime(0,0,0, $month, 1, $year));

// pocet dnu v danem mesici
$count_days = date('t', mktime(0,0,0, $month, 1, $year));

// cislo prvniho dne v mesici (1 = pondeli, ...)
$first = date('w', mktime(0,0,0,$month,1,$year));
if ($first == 0) $first = 7;

echo '<table cellspacing="0" class="calendar">';
echo '<tr><td align="center" colspan="8">';

// predchozi, aktualni a nasledujici mesic
echo '<a href="stat.php?month=' . ($month-1) . '&amp;year=' . $year . '">&lt;&lt;</a>&nbsp;&nbsp;&nbsp;';
dateLink(1, $count_days, $month . " / " . $year);    // odkaz na mesicni statistiku
echo '&nbsp;&nbsp;&nbsp;<a href="stat.php?month=' . ($month+1) . '&amp;year=' . $year .  '">&gt;&gt;</a>';

echo '</td></tr>';
echo '<tr><td>T</td><td>Po</td><td>t</td><td>St</td><td>t</td><td>P</td><td>So</td><td>Ne</td></tr>';

$day = 0;
// cyklus pres tydny
for ($x = 0; $x <= 5;$x++) {
    echo '<tr><td align="center"><strong>';

    // zjisti posledni den v danem tydnu
    if ($x == 0)    // prvni tyden
        $end = 7 - $first+1;
    elseif ($day+7 >= $count_days)    // posledni tyden
        $end = $count_days;
    else    // zbyle tydny
        $end = $day+7;

    // odkaz na tydenni statistiku
    dateLink($day+1, $end, $x+1);

    echo '</strong></td>';
    
    // cyklus pres dny v tydnu
    for ($i = 1;$i <= 7;$i++) {
        echo '<td>';
        $day = $x*7 + $i - $first+1; // spocti den
        
        // je to platne datum
        if ($day >= 1 and $day <= $count_days )
            dateLink($day, $day, $day); // odkaz na denni statistiku
        else
            echo "&nbsp;";

        echo '</td>';
    }

    echo '</tr>';

    // pokud neexistuje nasledujici datum, ukonci cyklus
    if (!checkdate($month, $day+1, $year)) break;
}

echo '</table>';

?>