<?php
/*=======================================================================
// File:	JPGRAPH_PIE3D.PHP
// Description: 3D Pie plot extension for JpGraph
// Created: 	2001-03-24
// Ver:		$Id: jpgraph_pie3d.php 782 2006-10-08 08:09:02Z ljp $
//
// Copyright (c) Aditus Consulting. All rights reserved.
//========================================================================
*/

//===================================================
// CLASS PiePlot3D
// Description: Plots a 3D pie with a specified projection 
// angle between 20 and 70 degrees.
//===================================================
class PiePlot3D extends PiePlot {
    var $labelhintcolor="red",$showlabelhint=true;
    var $angle=50;	
    var $edgecolor="", $edgeweight=1;
    var $iThickness=false;
	
//---------------
// CONSTRUCTOR
    function PiePlot3d(&$data) {
	$this->radius = 0.5;
	$this->data = $data;
	$this->title = new Text("");
	$this->title->SetFont(FF_FONT1,FS_BOLD);
	$this->value = new DisplayValue();
	$this->value->Show();
	$this->value->SetFormat('%.0f%%');
    }

//---------------
// PUBLIC METHODS	
	
    // Set label arrays
    function SetLegends($aLegend) {
	$this->legends = array_reverse(array_slice($aLegend,0,count($this->data)));
    }

    function SetSliceColors($aColors) {
	$this->setslicecolors = $aColors;
    }

    function Legend(&$aGraph) {
	parent::Legend($aGraph);
	$aGraph->legend->txtcol = array_reverse($aGraph->legend->txtcol);
    }

    function SetCSIMTargets($targets,$alts=null) {
	$this->csimtargets = $targets;
	$this->csimalts = $alts;
    }

    // Should the slices be separated by a line? If color is specified as "" no line
    // will be used to separate pie slices.
    function SetEdge($aColor='black',$aWeight=1) {
	$this->edgecolor = $aColor;
	$this->edgeweight = $aWeight;
    }

    // Dummy function to make Pie3D behave in a similair way to 2D
    function ShowBorder($exterior=true,$interior=true) {
	JpGraphError::RaiseL(14001);
//('Pie3D::ShowBorder() . Deprecated function. Use Pie3D::SetEdge() to control the edges around slices.');
    }

    // Specify projection angle for 3D in degrees
    // Must be between 20 and 70 degrees
    function SetAngle($a) {
	if( $a<5 || $a>90 )
	    JpGraphError::RaiseL(14002);
//("PiePlot3D::SetAngle() 3D Pie projection angle must be between 5 and 85 degrees.");
	else
	    $this->angle = $a;
    }

    function AddSliceToCSIM($i,$xc,$yc,$height,$width,$thick,$sa,$ea) {  //Slice number, ellipse centre (x,y), height, width, start angle, end angle

	$sa *= M_PI/180;
	$ea *= M_PI/180;

	//add coordinates of the centre to the map
	$coords = "$xc, $yc";

	//add coordinates of the first point on the arc to the map
	$xp = floor($width*cos($sa)/2+$xc);
	$yp = floor($yc-$height*sin($sa)/2);
	$coords.= ", $xp, $yp";

	//If on the front half, add the thickness offset
	if ($sa >= M_PI && $sa <= 2*M_PI*1.01) {
	    $yp = floor($yp+$thick);
	    $coords.= ", $xp, $yp";
	}
		
	//add coordinates every 0.2 radians
	$a=$sa+0.2;
	while ($a<$ea) {
	    $xp = floor($width*cos($a)/2+$xc);
	    if ($a >= M_PI && $a <= 2*M_PI*1.01) {
		$yp = floor($yc-($height*sin($a)/2)+$thick);
	    } else {
		$yp = floor($yc-$height*sin($a)/2);
	    }
	    $coords.= ", $xp, $yp";
	    $a += 0.2;
	}
		
	//Add the last point on the arc
	$xp = floor($width*cos($ea)/2+$xc);
	$yp = floor($yc-$height*sin($ea)/2);


	if ($ea >= M_PI && $ea <= 2*M_PI*1.01) {
	    $coords.= ", $xp, ".floor($yp+$thick);
	}
	$coords.= ", $xp, $yp";
	$alt='';
	if( !empty($this->csimalts[$i]) ) {										
	    $tmp=sprintf($this->csimalts[$i],$this->data[$i]);
	    $alt="alt=\"$tmp\" title=\"$tmp\"";
	}
	if( !empty($this->csimtargets[$i]) )
	    $this->csimareas .= "<area shape=\"poly\" coords=\"$coords\" href=\"".$this->csimtargets[$i]."\" $alt />\n";
    }

    function SetLabels($aLabels,$aLblPosAdj="auto") {
	$this->labels = $aLabels;
	$this->ilabelposadj=$aLblPosAdj;
    }

	
    // Distance from the pie to the labels
    function SetLabelMargin($m) {
	$this->value->SetMargin($m);
    }
	
    // Show a thin line from the pie to the label for a specific slice
    function ShowLabelHint($f=true) {
	$this->showlabelhint=$f;
    }
	
    // Set color of hint line to label for each slice
    function SetLabelHintColor($c) {
	$this->labelhintcolor=$c;
    }

    function SetHeight($aHeight) {
      $this->iThickness = $aHeight;
    }


// Normalize Angle between 0-360
    function NormAngle($a) {
	// Normalize anle to 0 to 2M_PI
	// 
	if( $a > 0 ) {
	    while($a > 360) $a -= 360;
	}
	else {
	    while($a < 0) $a += 360;
	}
	if( $a < 0 )
	    $                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  